package doABC;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class InstructionJump extends Instruction{

	public Instruction toIns; //instrukcja do ktorej skacze
	
	public InstructionJump(int opcode, byte[] operands){
		super(opcode, operands);
	}
	
	public InstructionJump(int opcode, byte[] operands, int position){
		super(opcode, operands, position);
	}
	
	public ByteBuffer getBytes(){
		//alokuj odpowiedni ilo dla wczytanego pliku
		ByteBuffer bbuf = ByteBuffer.allocate(1+operands.length);
		//Ustawiam kolejno bitw na LITTLE ENDIAN
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.put((byte) opcode);
		if (operands.length>0){
			bbuf.put(operands);
		}
		
		return bbuf;
	}
	
	public ArrayList<Byte> getBytes2(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		result.add((byte) opcode);
		if (operands.length>0){
			for (byte b : operands){
				result.add(b);
			}
		}
		return result;
	}
	
}
